/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);

    private JdbcUtils() {
    }

    public static void closeConnection(Connection connection) {
        block5: {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Could not close JDBC Connection", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("Unexpected exception on closing JDBC Connection", ex);
                }
            }
        }
    }

    public static void closeStatement(Statement statement) {
        block5: {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Could not close JDBC Statement", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("Unexpected exception on closing JDBC Statement", ex);
                }
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        block5: {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Could not close JDBC ResultSet", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("Unexpected exception on closing JDBC ResultSet", ex);
                }
            }
        }
    }
}

