/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.json.ValueFaultHandler;
import org.jolokia.converter.object.StringToObjectConverter;
import org.json.simple.JSONArray;

public class ListExtractor
implements Extractor {
    @Override
    public Class getType() {
        return List.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        String pathPart;
        List list = (List)pValue;
        int length = pConverter.getCollectionLength(list.size());
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            return this.extractWithPath(pConverter, list, pPathParts, jsonify, pathPart);
        }
        return jsonify ? this.extractListAsJson(pConverter, list, pPathParts, length) : list;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pIndex, Object pValue) throws IllegalAccessException, InvocationTargetException {
        int idx;
        List list = (List)pInner;
        try {
            idx = Integer.parseInt(pIndex);
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Non-numeric index for accessing collection " + pInner + ". (index = " + pIndex + ", value to set = " + pValue + ")", exp);
        }
        Object oldValue = list.get(idx);
        Object value = oldValue != null ? pConverter.prepareValue(oldValue.getClass().getName(), pValue) : pValue;
        list.set(idx, value);
        return oldValue;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    private Object extractWithPath(ObjectToJsonConverter pConverter, List pList, Stack<String> pStack, boolean jsonify, String pPathPart) throws AttributeNotFoundException {
        try {
            int idx = Integer.parseInt(pPathPart);
            return pConverter.extractObject(pList.get(idx), pStack, jsonify);
        }
        catch (NumberFormatException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException(new AttributeNotFoundException("Index '" + pPathPart + "' is not numeric for accessing list"));
        }
        catch (IndexOutOfBoundsException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException(new AttributeNotFoundException("Index '" + pPathPart + "' is out-of-bound for a list of size " + pList.size()));
        }
    }

    private Object extractListAsJson(ObjectToJsonConverter pConverter, List pList, Stack<String> pPath, int pLength) throws AttributeNotFoundException {
        JSONArray ret = new JSONArray();
        for (int i = 0; i < pLength; ++i) {
            Stack path = (Stack)pPath.clone();
            try {
                ret.add(pConverter.extractObject(pList.get(i), path, true));
                continue;
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {
                // empty catch block
            }
        }
        if (ret.isEmpty() && pLength > 0) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }
}

