/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.ArrayList;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.PingIterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class PingCommand
extends Shell.Command {
    private Option tserverOption;
    private Option disablePaginationOpt;

    @Override
    public String description() {
        return "ping tablet servers";
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        ArrayList<String> tservers;
        boolean paginate;
        InstanceOperations instanceOps = shellState.getAccumuloClient().instanceOperations();
        boolean bl = paginate = !cl.hasOption(this.disablePaginationOpt.getOpt());
        if (cl.hasOption(this.tserverOption.getOpt())) {
            tservers = new ArrayList<String>();
            tservers.add(cl.getOptionValue(this.tserverOption.getOpt()));
        } else {
            tservers = instanceOps.getTabletServers();
        }
        shellState.printLines(new PingIterator(tservers, instanceOps), paginate);
        return 0;
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        this.tserverOption = new Option("ts", "tabletServer", true, "tablet server to ping");
        this.tserverOption.setArgName("tablet server");
        opts.addOption(this.tserverOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        opts.addOption(this.disablePaginationOpt);
        return opts;
    }
}

