/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.ShellPluginConfigurationCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class FormatterCommand
extends ShellPluginConfigurationCommand {
    private Option interpeterOption;

    public FormatterCommand() {
        super("formatter", Property.TABLE_FORMATTER_CLASS, "f");
    }

    @Override
    public String description() {
        return "specifies a formatter to use for displaying table entries";
    }

    public static Class<? extends Formatter> getCurrentFormatter(String tableName, Shell shellState) {
        return ShellPluginConfigurationCommand.getPluginClass(tableName, shellState, Formatter.class, Property.TABLE_FORMATTER_CLASS);
    }

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        this.interpeterOption = new Option("i", "interpeter", false, "configure class as interpreter also");
        options.addOption(this.interpeterOption);
        return options;
    }

    @Override
    protected void setPlugin(CommandLine cl, Shell shellState, String tableName, String className) throws AccumuloException, AccumuloSecurityException {
        super.setPlugin(cl, shellState, tableName, className);
        if (cl.hasOption(this.interpeterOption.getOpt())) {
            shellState.getAccumuloClient().tableOperations().setProperty(tableName, Property.TABLE_INTERPRETER_CLASS.toString(), className);
        }
    }

    @Override
    protected void removePlugin(CommandLine cl, Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException {
        super.removePlugin(cl, shellState, tableName);
        if (cl.hasOption(this.interpeterOption.getOpt())) {
            shellState.getAccumuloClient().tableOperations().removeProperty(tableName, Property.TABLE_INTERPRETER_CLASS.toString());
        }
    }
}

