/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.client.admin.ActiveScan;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.ScanType;
import org.apache.accumulo.core.util.DurationFormat;

class ActiveScanIterator
implements Iterator<String> {
    private InstanceOperations instanceOps;
    private Iterator<String> tsIter;
    private Iterator<String> scansIter;

    private void readNext() {
        ArrayList<Object> scans = new ArrayList<Object>();
        while (this.tsIter.hasNext()) {
            String tserver = this.tsIter.next();
            try {
                List asl = this.instanceOps.getActiveScans(tserver);
                for (ActiveScan as : asl) {
                    DurationFormat dur = new DurationFormat(as.getAge(), "");
                    DurationFormat dur2 = new DurationFormat(as.getLastContactTime(), "");
                    scans.add(String.format("%21s |%21s |%9s |%9s |%7s |%6s |%8s |%8s |%10s |%20s |%10s |%20s |%10s | %s", tserver, as.getClient(), dur, dur2, as.getState(), as.getType(), as.getUser(), as.getTable(), as.getColumns(), as.getAuthorizations(), as.getType() == ScanType.SINGLE ? as.getTablet() : "N/A", as.getScanid(), as.getSsiList(), as.getSsio()));
                }
            }
            catch (Exception e) {
                scans.add(tserver + " ERROR " + e.getMessage());
            }
            if (scans.isEmpty()) continue;
            break;
        }
        this.scansIter = scans.iterator();
    }

    ActiveScanIterator(List<String> tservers, InstanceOperations instanceOps) {
        this.instanceOps = instanceOps;
        this.tsIter = tservers.iterator();
        String header = String.format(" %-21s| %-21s| %-9s| %-9s| %-7s| %-6s| %-8s| %-8s| %-10s| %-20s| %-10s| %-10s | %-20s | %s", "TABLET SERVER", "CLIENT", "AGE", "LAST", "STATE", "TYPE", "USER", "TABLE", "COLUMNS", "AUTHORIZATIONS", "TABLET", "SCAN ID", "ITERATORS", "ITERATOR OPTIONS");
        this.scansIter = Collections.singletonList(header).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.scansIter.hasNext();
    }

    @Override
    public String next() {
        String next = this.scansIter.next();
        if (!this.scansIter.hasNext()) {
            this.readNext();
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

