/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.clone;

import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.clone.CloneInfo;
import org.apache.accumulo.manager.tableOps.clone.CloneZookeeper;
import org.slf4j.LoggerFactory;

class ClonePermissions
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final CloneInfo cloneInfo;

    public ClonePermissions(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager environment) throws Exception {
        for (TablePermission permission : TablePermission.values()) {
            try {
                environment.getContext().getSecurityOperation().grantTablePermission(environment.getContext().rpcCreds(), this.cloneInfo.getUser(), this.cloneInfo.getTableId(), this.cloneInfo.getTableName(), permission, this.cloneInfo.getNamespaceId());
            }
            catch (ThriftSecurityException e) {
                LoggerFactory.getLogger(ClonePermissions.class).error("{}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
        }
        try {
            return new CloneZookeeper(this.cloneInfo, (ClientContext)environment.getContext());
        }
        catch (NamespaceNotFoundException e) {
            throw new AcceptableThriftTableOperationException(null, this.cloneInfo.getTableName(), TableOperation.CLONE, TableOperationExceptionType.NAMESPACE_NOTFOUND, "Namespace for target table not found");
        }
    }

    @Override
    public void undo(long tid, Manager environment) throws Exception {
        environment.getContext().getSecurityOperation().deleteTable(environment.getContext().rpcCreds(), this.cloneInfo.getTableId(), this.cloneInfo.getNamespaceId());
    }
}

