/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.replication;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StatusMaker {
    private static final Logger log = LoggerFactory.getLogger(StatusMaker.class);
    private final AccumuloClient client;
    private final VolumeManager fs;
    private BatchWriter replicationWriter;
    private BatchWriter metadataWriter;
    private String sourceTableName = MetadataTable.NAME;

    public StatusMaker(AccumuloClient client, VolumeManager fs) {
        this.client = client;
        this.fs = fs;
    }

    public void setSourceTableName(String table) {
        this.sourceTableName = table;
    }

    public void run() {
        Span span = TraceUtil.startSpan(this.getClass(), (String)"replicationStatusMaker");
        try (Scope scope = span.makeCurrent();){
            Scanner s;
            try {
                s = this.client.createScanner(this.sourceTableName, Authorizations.EMPTY);
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException(e);
            }
            s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            Text file = new Text();
            for (Map.Entry entry : s) {
                Replication.Status status;
                if (this.replicationWriter == null) {
                    try {
                        ReplicationTable.setOnline((AccumuloClient)this.client);
                        this.replicationWriter = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
                    }
                    catch (AccumuloException | AccumuloSecurityException | ReplicationTableOfflineException e) {
                        log.warn("Replication table did not come online");
                        this.replicationWriter = null;
                        if (scope != null) {
                            scope.close();
                        }
                        span.end();
                        return;
                    }
                }
                MetadataSchema.ReplicationSection.getFile((Key)((Key)entry.getKey()), (Text)file);
                TableId tableId = MetadataSchema.ReplicationSection.getTableId((Key)((Key)entry.getKey()));
                try {
                    status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                }
                catch (InvalidProtocolBufferException e) {
                    log.warn("Could not deserialize protobuf for {}", (Object)file);
                    continue;
                }
                log.debug("Creating replication status record for {} on table {} with {}.", new Object[]{file, tableId, ProtobufUtil.toString((GeneratedMessageV3)status)});
                Span childSpan = TraceUtil.startSpan(this.getClass(), (String)"createStatusMutations");
                try {
                    Scope childScope = span.makeCurrent();
                    try {
                        if (!this.addStatusRecord(file, tableId, (Value)entry.getValue())) {
                            continue;
                        }
                    }
                    finally {
                        if (childScope == null) continue;
                        childScope.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)childSpan, (Throwable)e, (boolean)true);
                    throw e;
                }
                finally {
                    childSpan.end();
                    continue;
                }
                if (!status.getClosed()) continue;
                Span closedSpan = TraceUtil.startSpan(this.getClass(), (String)"recordStatusOrder");
                try {
                    Scope childScope = closedSpan.makeCurrent();
                    try {
                        if (!this.addOrderRecord(file, tableId, status, (Value)entry.getValue())) {
                            continue;
                        }
                    }
                    finally {
                        if (childScope == null) continue;
                        childScope.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)closedSpan, (Throwable)e, (boolean)true);
                    throw e;
                }
                finally {
                    closedSpan.end();
                    continue;
                }
                Span deleteSpan = TraceUtil.startSpan(this.getClass(), (String)"deleteClosedStatus");
                try {
                    Scope childScope = deleteSpan.makeCurrent();
                    try {
                        this.deleteStatusRecord((Key)entry.getKey());
                    }
                    finally {
                        if (childScope == null) continue;
                        childScope.close();
                    }
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)deleteSpan, (Throwable)e, (boolean)true);
                    throw e;
                }
                finally {
                    deleteSpan.end();
                }
            }
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addStatusRecord(Text file, TableId tableId, Value v) {
        try {
            Mutation m = new Mutation(file);
            m.put(ReplicationSchema.StatusSection.NAME, new Text(tableId.canonical()), v);
            try {
                this.replicationWriter.addMutation(m);
            }
            catch (MutationsRejectedException e) {
                log.warn("Failed to write work mutations for replication, will retry", (Throwable)e);
                boolean bl = false;
                try {
                    this.replicationWriter.flush();
                }
                catch (MutationsRejectedException e2) {
                    log.warn("Failed to write work mutations for replication, will retry", (Throwable)e2);
                    return false;
                }
                return bl;
            }
        }
        finally {
            try {
                this.replicationWriter.flush();
            }
            catch (MutationsRejectedException e) {
                log.warn("Failed to write work mutations for replication, will retry", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean addOrderRecord(Text file, TableId tableId, Replication.Status stat, Value value) {
        block21: {
            try {
                if (!stat.hasCreatedTime()) {
                    try {
                        long createdTime = this.setAndGetCreatedTime(new Path(file.toString()), tableId.toString());
                        stat = Replication.Status.newBuilder((Replication.Status)stat).setCreatedTime(createdTime).build();
                        value = ProtobufUtil.toValue((GeneratedMessageV3)stat);
                        log.debug("Status was lacking createdTime, set to {} for {}", (Object)createdTime, (Object)file);
                    }
                    catch (IOException e) {
                        log.warn("Failed to get file status, will retry", (Throwable)e);
                        boolean bl = false;
                        try {
                            this.replicationWriter.flush();
                        }
                        catch (MutationsRejectedException e2) {
                            log.warn("Failed to write order mutation for replication, will retry", (Throwable)e2);
                            return false;
                        }
                        return bl;
                    }
                    catch (MutationsRejectedException e) {
                        log.warn("Failed to write status mutation for replication, will retry", (Throwable)e);
                        boolean bl = false;
                        try {
                            this.replicationWriter.flush();
                        }
                        catch (MutationsRejectedException e3) {
                            log.warn("Failed to write order mutation for replication, will retry", (Throwable)e3);
                            return false;
                        }
                        return bl;
                    }
                }
                log.info("Creating order record for {} for {} with {}", new Object[]{file, tableId, ProtobufUtil.toString((GeneratedMessageV3)stat)});
                Mutation m = ReplicationSchema.OrderSection.createMutation((String)file.toString(), (long)stat.getCreatedTime());
                ReplicationSchema.OrderSection.add((Mutation)m, (TableId)tableId, (Value)value);
                try {
                    this.replicationWriter.addMutation(m);
                    break block21;
                }
                catch (MutationsRejectedException e) {
                    log.warn("Failed to write order mutation for replication, will retry", (Throwable)e);
                    boolean bl = false;
                    try {
                        this.replicationWriter.flush();
                    }
                    catch (MutationsRejectedException e4) {
                        log.warn("Failed to write order mutation for replication, will retry", (Throwable)e4);
                        return false;
                    }
                    return bl;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    this.replicationWriter.flush();
                }
                catch (MutationsRejectedException e) {
                    log.warn("Failed to write order mutation for replication, will retry", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    protected void deleteStatusRecord(Key k) {
        log.debug("Deleting {} from metadata table as it's no longer needed", (Object)k.toStringNoTruncate());
        if (this.metadataWriter == null) {
            try {
                this.metadataWriter = this.client.createBatchWriter(this.sourceTableName);
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException("Metadata table doesn't exist");
            }
        }
        try {
            Mutation m = new Mutation(k.getRow());
            m.putDelete(k.getColumnFamily(), k.getColumnQualifier());
            this.metadataWriter.addMutation(m);
            this.metadataWriter.flush();
        }
        catch (MutationsRejectedException e) {
            log.warn("Failed to delete status mutations for metadata table, will retry", (Throwable)e);
        }
    }

    private long setAndGetCreatedTime(Path file, String tableId) throws IOException, MutationsRejectedException {
        long createdTime = this.fs.exists(file) ? this.fs.getFileStatus(file).getModificationTime() : System.currentTimeMillis();
        Replication.Status status = Replication.Status.newBuilder().setCreatedTime(createdTime).build();
        Mutation m = new Mutation(new Text(MetadataSchema.ReplicationSection.getRowPrefix() + String.valueOf(file)));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId), ProtobufUtil.toValue((GeneratedMessageV3)status));
        this.replicationWriter.addMutation(m);
        this.replicationWriter.flush();
        return createdTime;
    }
}

