/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoop.mapred;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.hadoop.mapreduce.InputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapred.AccumuloRecordReader;
import org.apache.accumulo.hadoopImpl.mapreduce.InputFormatBuilderImpl;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloInputFormat
implements InputFormat<Key, Value> {
    private static final Class<AccumuloInputFormat> CLASS = AccumuloInputFormat.class;
    private static final Logger log = LoggerFactory.getLogger(CLASS);

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return AccumuloRecordReader.getSplits(job, CLASS);
    }

    public RecordReader<Key, Value> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        AccumuloRecordReader<Key, Value> recordReader = new AccumuloRecordReader<Key, Value>(CLASS){

            public boolean next(Key key, Value value) {
                if (this.scannerIterator.hasNext()) {
                    ++this.numKeysRead;
                    Map.Entry entry = (Map.Entry)this.scannerIterator.next();
                    this.currentKey = (Key)entry.getKey();
                    key.set(this.currentKey);
                    value.set(((Value)entry.getValue()).get());
                    if (log.isTraceEnabled()) {
                        log.trace("Processing key/value pair: " + DefaultFormatter.formatEntry((Map.Entry)entry, (boolean)true));
                    }
                    return true;
                }
                return false;
            }

            public Key createKey() {
                return new Key();
            }

            public Value createValue() {
                return new Value();
            }
        };
        recordReader.initialize(split, job);
        return recordReader;
    }

    public static InputFormatBuilder.ClientParams<JobConf> configure() {
        return new InputFormatBuilderImpl<JobConf>(CLASS);
    }
}

