/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.spi.compaction.CompactionExecutorId;
import org.apache.accumulo.core.spi.compaction.CompactionJob;
import org.apache.accumulo.core.spi.compaction.CompactionKind;

public class CompactionJobImpl
implements CompactionJob {
    private final short priority;
    private final CompactionExecutorId executor;
    private final Set<CompactableFile> files;
    private final CompactionKind kind;
    private final Optional<Boolean> jobSelectedAll;

    public CompactionJobImpl(short priority, CompactionExecutorId executor, Collection<CompactableFile> files, CompactionKind kind, Optional<Boolean> jobSelectedAll) {
        this.priority = priority;
        this.executor = Objects.requireNonNull(executor);
        this.files = Set.copyOf(files);
        this.kind = Objects.requireNonNull(kind);
        this.jobSelectedAll = Objects.requireNonNull(jobSelectedAll);
    }

    @Override
    public short getPriority() {
        return this.priority;
    }

    @Override
    public CompactionExecutorId getExecutor() {
        return this.executor;
    }

    @Override
    public Set<CompactableFile> getFiles() {
        return this.files;
    }

    @Override
    public CompactionKind getKind() {
        return this.kind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.priority, this.executor, this.files, this.kind});
    }

    public boolean selectedAll() {
        return this.jobSelectedAll.orElseThrow();
    }

    public boolean equals(Object o) {
        if (o instanceof CompactionJobImpl) {
            CompactionJobImpl ocj = (CompactionJobImpl)o;
            return this.priority == ocj.priority && this.executor.equals(ocj.executor) && this.files.equals(ocj.files) && this.kind == ocj.kind;
        }
        return false;
    }

    public String toString() {
        return "CompactionJob [priority=" + this.priority + ", executor=" + String.valueOf(this.executor) + ", files=" + String.valueOf(this.files) + ", kind=" + String.valueOf((Object)this.kind) + "]";
    }
}

