/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class Interner<T> {
    private final WeakHashMap<T, WeakReference<T>> internTable = new WeakHashMap();

    public synchronized T intern(T item) {
        Object oldItem;
        WeakReference<T> ref = this.internTable.get(item);
        if (ref != null && (oldItem = ref.get()) != null) {
            return oldItem;
        }
        this.internTable.put(item, new WeakReference<T>(item));
        return item;
    }

    synchronized int size() {
        return this.internTable.size();
    }
}

