/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc.clients;

import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.process.thrift.ServerProcessService;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;

public class ServerProcessServiceThriftClient
extends ThriftClientTypes<ServerProcessService.Client> {
    protected ServerProcessServiceThriftClient(String serviceName) {
        super(serviceName, new ServerProcessService.Client.Factory());
    }

    public ServerProcessService.Client getServerProcessConnection(ClientContext context, Logger log, String hostname, int port) {
        HostAndPort serverProcess = HostAndPort.fromParts(hostname, port);
        try {
            return ThriftUtil.getClientNoTimeout(this, serverProcess, context);
        }
        catch (TTransportException tte) {
            Throwable cause = tte.getCause();
            if (cause instanceof UnknownHostException) {
                throw new UncheckedIOException((UnknownHostException)cause);
            }
            log.debug("Failed to connect to process at " + String.valueOf(serverProcess) + ", will retry... ", (Throwable)tte);
            return null;
        }
    }
}

