/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.clientImpl.ClientConfConverter;
import org.apache.accumulo.core.clientImpl.DelegationTokenImpl;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.rpc.SaslClientDigestCallbackHandler;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslConnectionParams {
    private static final Logger log = LoggerFactory.getLogger(SaslConnectionParams.class);
    private static String defaultRealm;
    protected String principal;
    protected QualityOfProtection qop;
    protected String kerberosServerPrimary;
    protected SaslMechanism mechanism;
    protected CallbackHandler callbackHandler;
    protected final Map<String, String> saslProperties;

    public SaslConnectionParams(AccumuloConfiguration conf, AuthenticationToken token) {
        this(ClientConfConverter.toProperties(conf), token);
    }

    public SaslConnectionParams(Properties properties, AuthenticationToken token) {
        Objects.requireNonNull(properties, "Properties was null");
        Objects.requireNonNull(token, "AuthenticationToken was null");
        this.saslProperties = new HashMap<String, String>();
        this.updatePrincipalFromUgi();
        this.updateFromConfiguration(properties);
        this.updateFromToken(token);
    }

    public static SaslConnectionParams from(AccumuloConfiguration config, AuthenticationToken token) {
        if (!config.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            return null;
        }
        return new SaslConnectionParams(config, token);
    }

    protected void updateFromToken(AuthenticationToken token) {
        if (token instanceof KerberosToken) {
            this.mechanism = SaslMechanism.GSSAPI;
            this.callbackHandler = null;
        } else if (token instanceof DelegationTokenImpl) {
            this.mechanism = SaslMechanism.DIGEST_MD5;
            this.callbackHandler = new SaslClientDigestCallbackHandler((DelegationTokenImpl)token);
        } else {
            throw new IllegalArgumentException("Cannot determine SASL mechanism for token class: " + String.valueOf(token.getClass()));
        }
    }

    protected void updatePrincipalFromUgi() {
        UserGroupInformation currentUser;
        if (!UserGroupInformation.isSecurityEnabled()) {
            throw new RuntimeException("Cannot use SASL if Hadoop security is not enabled");
        }
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get current user", e);
        }
        this.principal = currentUser.getUserName();
        if (this.principal == null) {
            throw new RuntimeException("Got null username from " + String.valueOf(currentUser));
        }
    }

    protected void updateFromConfiguration(Properties properties) {
        String qopValue = ClientProperty.SASL_QOP.getValue(properties);
        this.qop = QualityOfProtection.get(qopValue);
        this.saslProperties.put("javax.security.sasl.qop", this.qop.getQuality());
        this.kerberosServerPrimary = ClientProperty.SASL_KERBEROS_SERVER_PRIMARY.getValue(properties);
    }

    public Map<String, String> getSaslProperties() {
        return Collections.unmodifiableMap(this.saslProperties);
    }

    public QualityOfProtection getQualityOfProtection() {
        return this.qop;
    }

    public String getKerberosServerPrimary() {
        return this.kerberosServerPrimary;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public SaslMechanism getMechanism() {
        return this.mechanism;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(23, 29);
        hcb.append((Object)this.kerberosServerPrimary).append(this.saslProperties).append(this.qop.hashCode()).append((Object)this.principal).append((Object)this.mechanism).append((Object)this.callbackHandler);
        return hcb.toHashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SaslConnectionParams) {
            SaslConnectionParams other = (SaslConnectionParams)o;
            if (!this.kerberosServerPrimary.equals(other.kerberosServerPrimary)) {
                return false;
            }
            if (this.qop != other.qop) {
                return false;
            }
            if (!this.principal.equals(other.principal)) {
                return false;
            }
            if (!this.mechanism.equals((Object)other.mechanism)) {
                return false;
            }
            if (this.callbackHandler == null ? other.callbackHandler != null : !this.callbackHandler.equals(other.callbackHandler)) {
                return false;
            }
            return this.saslProperties.equals(other.saslProperties);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("SaslConnectionParams[").append("kerberosServerPrimary=").append(this.kerberosServerPrimary).append(", qualityOfProtection=").append((Object)this.qop);
        sb.append(", principal=").append(this.principal).append(", mechanism=").append((Object)this.mechanism).append(", callbackHandler=").append(this.callbackHandler).append("]");
        return sb.toString();
    }

    public static String getDefaultRealm() {
        return defaultRealm;
    }

    static {
        try {
            defaultRealm = KerberosUtil.getDefaultRealm();
        }
        catch (Exception ke) {
            log.debug("Kerberos krb5 configuration not found, setting default realm to empty");
            defaultRealm = "UNKNOWN";
        }
    }

    public static enum SaslMechanism {
        GSSAPI("GSSAPI"),
        DIGEST_MD5("DIGEST-MD5");

        private final String mechanismName;

        private SaslMechanism(String mechanismName) {
            this.mechanismName = mechanismName;
        }

        public String getMechanismName() {
            return this.mechanismName;
        }

        public static SaslMechanism get(String mechanismName) {
            if (SaslMechanism.GSSAPI.mechanismName.equals(mechanismName)) {
                return GSSAPI;
            }
            if (SaslMechanism.DIGEST_MD5.mechanismName.equals(mechanismName)) {
                return DIGEST_MD5;
            }
            throw new IllegalArgumentException("No value for " + mechanismName);
        }
    }

    public static enum QualityOfProtection {
        AUTH("auth"),
        AUTH_INT("auth-int"),
        AUTH_CONF("auth-conf");

        private final String quality;

        private QualityOfProtection(String quality) {
            this.quality = quality;
        }

        public String getQuality() {
            return this.quality;
        }

        public static QualityOfProtection get(String name) {
            if (QualityOfProtection.AUTH.quality.equals(name)) {
                return AUTH;
            }
            if (QualityOfProtection.AUTH_INT.quality.equals(name)) {
                return AUTH_INT;
            }
            if (QualityOfProtection.AUTH_CONF.quality.equals(name)) {
                return AUTH_CONF;
            }
            throw new IllegalArgumentException("No value for " + name);
        }

        public String toString() {
            return this.quality;
        }
    }
}

