/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.manager.balancer;

import java.util.Objects;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.spi.balancer.data.TabletStatistics;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;

public class TabletStatisticsImpl
implements TabletStatistics {
    private final TabletStats thriftStats;
    private final TabletId tabletId;

    public TabletStatisticsImpl(TabletStats thriftStats) {
        this.thriftStats = Objects.requireNonNull(thriftStats);
        this.tabletId = new TabletIdImpl(KeyExtent.fromThrift(thriftStats.getExtent()));
    }

    @Override
    public TabletId getTabletId() {
        return this.tabletId;
    }

    @Override
    public long getNumEntries() {
        return this.thriftStats.getNumEntries();
    }

    @Override
    public long getSplitCreationTime() {
        return this.thriftStats.getSplitCreationTime();
    }

    @Override
    public double getIngestRate() {
        return this.thriftStats.getIngestRate();
    }

    @Override
    public double getQueryRate() {
        return this.thriftStats.getQueryRate();
    }

    @Override
    public int compareTo(TabletStatistics o) {
        return this.thriftStats.compareTo(((TabletStatisticsImpl)o).thriftStats);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TabletStatisticsImpl that = (TabletStatisticsImpl)o;
        return this.thriftStats.equals(that.thriftStats);
    }

    public int hashCode() {
        return this.thriftStats.hashCode();
    }

    public String toString() {
        return this.thriftStats.toString();
    }
}

