/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.logging;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.apache.accumulo.core.util.Pair;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.AbstractLogger;

public abstract class ConditionalLogger
extends AbstractLogger {
    private static final long serialVersionUID = 1L;
    protected final Logger delegate;
    protected final BiFunction<String, List<Object>, Boolean> condition;

    protected ConditionalLogger(Logger log, BiFunction<String, List<Object>, Boolean> condition) {
        this.delegate = log;
        this.condition = condition;
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    public String getName() {
        return this.delegate.getName();
    }

    protected String getFullyQualifiedCallerName() {
        return this.delegate.getName();
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String messagePattern, Object[] arguments, Throwable throwable) {
        if (arguments == null) {
            arguments = new Object[]{};
        }
        if (this.condition.apply(messagePattern, Arrays.asList(arguments)).booleanValue()) {
            this.delegate.atLevel(level).addMarker(marker).setCause(throwable).log(messagePattern, arguments);
        }
    }

    public static class DeduplicatingLogger
    extends ConditionalLogger {
        private static final long serialVersionUID = 1L;

        public DeduplicatingLogger(Logger log, final Duration threshold, final long maxCachedLogMessages) {
            super(log, new BiFunction<String, List<Object>, Boolean>(){
                private final Cache<Pair<String, List<Object>>, Boolean> cache;
                private final ConcurrentMap<Pair<String, List<Object>>, Boolean> cacheMap;
                {
                    this.cache = Caffeine.newBuilder().expireAfterWrite(threshold).maximumSize(maxCachedLogMessages).build();
                    this.cacheMap = this.cache.asMap();
                }

                @Override
                public Boolean apply(String msg, List<Object> args) {
                    return this.cacheMap.putIfAbsent(new Pair<String, List<Object>>(msg, args), true) == null;
                }
            });
        }
    }

    public static class EscalatingLogger
    extends DeduplicatingLogger {
        private static final long serialVersionUID = 1L;
        private final Level elevatedLevel;

        public EscalatingLogger(Logger log, Duration threshold, long maxCachedLogMessages, Level elevatedLevel) {
            super(log, threshold, maxCachedLogMessages);
            this.elevatedLevel = elevatedLevel;
        }

        @Override
        protected void handleNormalizedLoggingCall(Level level, Marker marker, String messagePattern, Object[] arguments, Throwable throwable) {
            if (arguments == null) {
                arguments = new Object[]{};
            }
            if (!((Boolean)this.condition.apply(messagePattern, Arrays.asList(arguments))).booleanValue()) {
                this.delegate.atLevel(level).addMarker(marker).setCause(throwable).log(messagePattern, arguments);
            } else {
                this.delegate.atLevel(this.elevatedLevel).addMarker(marker).setCause(throwable).log(messagePattern, arguments);
            }
        }
    }
}

