/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.streams;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.accumulo.core.util.ratelimit.NullRateLimiter;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.hadoop.fs.FSDataOutputStream;

public class RateLimitedOutputStream
extends DataOutputStream {
    private final RateLimiter writeLimiter;

    public RateLimitedOutputStream(FSDataOutputStream fsDataOutputStream, RateLimiter writeLimiter) {
        super((OutputStream)fsDataOutputStream);
        this.writeLimiter = writeLimiter == null ? NullRateLimiter.INSTANCE : writeLimiter;
    }

    @Override
    public synchronized void write(int i) throws IOException {
        this.writeLimiter.acquire(1L);
        this.out.write(i);
    }

    @Override
    public synchronized void write(byte[] buffer, int offset, int length) throws IOException {
        this.writeLimiter.acquire(length);
        this.out.write(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public long position() {
        return ((FSDataOutputStream)this.out).getPos();
    }
}

