/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data.constraints;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.constraints.Constraint;

public class DefaultKeySizeConstraint
implements Constraint {
    protected static final short MAX__KEY_SIZE_EXCEEDED_VIOLATION = 1;
    protected static final long maxSize = 0x100000L;
    static final List<Short> NO_VIOLATIONS = new ArrayList<Short>();

    @Override
    public String getViolationDescription(short violationCode) {
        switch (violationCode) {
            case 1: {
                return "Key was larger than 1MB";
            }
        }
        return null;
    }

    @Override
    public List<Short> check(Constraint.Environment env, Mutation mutation) {
        if (mutation.numBytes() < 0x100000L) {
            return NO_VIOLATIONS;
        }
        ArrayList<Short> violations = new ArrayList<Short>();
        for (ColumnUpdate cu : mutation.getUpdates()) {
            int size = mutation.getRow().length;
            size += cu.getColumnFamily().length;
            size += cu.getColumnQualifier().length;
            if ((long)(size += cu.getColumnVisibility().length) <= 0x100000L) continue;
            violations.add((short)1);
        }
        return violations;
    }
}

