/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.hadoop.io.Text;

public interface TabletId
extends Comparable<TabletId> {
    public static TabletId of(TableId tableId, Text endRow, Text prevEndRow) {
        KeyExtent ke = new KeyExtent(tableId, endRow, prevEndRow);
        return new TabletIdImpl(ke);
    }

    public static TabletId of(TableId tableId, String endRow, String prevEndRow) {
        KeyExtent ke = endRow == null && prevEndRow == null ? new KeyExtent(tableId, null, null) : (endRow == null ? new KeyExtent(tableId, null, new Text(prevEndRow)) : (prevEndRow == null ? new KeyExtent(tableId, new Text(endRow), null) : new KeyExtent(tableId, new Text(endRow), new Text(prevEndRow))));
        return new TabletIdImpl(ke);
    }

    public static TabletId of(TableId tableId, byte[] endRow, byte[] prevEndRow) {
        KeyExtent ke = endRow == null && prevEndRow == null ? new KeyExtent(tableId, null, null) : (endRow == null ? new KeyExtent(tableId, null, new Text(prevEndRow)) : (prevEndRow == null ? new KeyExtent(tableId, new Text(endRow), null) : new KeyExtent(tableId, new Text(endRow), new Text(prevEndRow))));
        return new TabletIdImpl(ke);
    }

    public TableId getTable();

    @Deprecated(since="2.1.0")
    public Text getTableId();

    public Text getEndRow();

    public Text getPrevEndRow();

    public Range toRange();
}

