/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.StreamSupport;
import org.apache.accumulo.core.conf.Property;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeprecatedPropertyUtil {
    private static final Logger log = LoggerFactory.getLogger(DeprecatedPropertyUtil.class);
    public static final PropertyRenamer MASTER_MANAGER_RENAMER = PropertyRenamer.renamePrefix(Property.MASTER_PREFIX.getKey(), Property.MANAGER_PREFIX.getKey());
    protected static final List<PropertyRenamer> renamers = new ArrayList<PropertyRenamer>(List.of(MASTER_MANAGER_RENAMER));

    public static String getReplacementName(String propertyName, BiConsumer<Logger, String> loggerActionOnReplace) {
        String replacement = Objects.requireNonNull(propertyName);
        Objects.requireNonNull(loggerActionOnReplace);
        for (PropertyRenamer renamer : renamers) {
            if (!renamer.keyFilter.test(replacement)) continue;
            replacement = (String)renamer.keyMapper.apply(replacement);
        }
        if (!replacement.equals(propertyName)) {
            loggerActionOnReplace.accept(log, replacement);
        }
        return replacement;
    }

    static void sanityCheckManagerProperties(AbstractConfiguration config) {
        boolean foundMasterPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(config.getKeys(), 16), false).anyMatch(DeprecatedPropertyUtil.MASTER_MANAGER_RENAMER.keyFilter);
        boolean foundManagerPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(config.getKeys(), 16), false).anyMatch(k -> k.startsWith(Property.MANAGER_PREFIX.getKey()));
        if (foundMasterPrefix && foundManagerPrefix) {
            throw new IllegalStateException("Found both old 'master.*' and new 'manager.*' naming conventions in the same startup configuration");
        }
    }

    public static class PropertyRenamer {
        final Predicate<String> keyFilter;
        final UnaryOperator<String> keyMapper;

        public PropertyRenamer(Predicate<String> keyFilter, UnaryOperator<String> keyMapper) {
            this.keyFilter = Objects.requireNonNull(keyFilter);
            this.keyMapper = Objects.requireNonNull(keyMapper);
        }

        public static PropertyRenamer renamePrefix(String oldPrefix, String newPrefix) {
            return new PropertyRenamer(p -> p.startsWith(oldPrefix), p -> newPrefix + p.substring(oldPrefix.length()));
        }
    }
}

