/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.NamespaceOperations;
import org.apache.accumulo.core.client.admin.ReplicationOperations;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.trace.TraceUtil;

@Deprecated(since="2.0.0")
public class ConnectorImpl
extends Connector {
    private static final String SYSTEM_TOKEN_NAME = "org.apache.accumulo.server.security.SystemCredentials$SystemToken";
    private final ClientContext context;

    public ConnectorImpl(ClientContext context) throws AccumuloSecurityException, AccumuloException {
        this.context = context;
        SingletonManager.setMode(SingletonManager.Mode.CONNECTOR);
        if (context.getCredentials().getToken().isDestroyed()) {
            throw new AccumuloSecurityException(context.getCredentials().getPrincipal(), SecurityErrorCode.TOKEN_EXPIRED);
        }
        String tokenClassName = context.getCredentials().getToken().getClass().getName();
        if (!SYSTEM_TOKEN_NAME.equals(tokenClassName) && !ThriftClientTypes.CLIENT.execute(context, client -> client.authenticate(TraceUtil.traceInfo(), context.rpcCreds())).booleanValue()) {
            throw new AccumuloSecurityException("Authentication failed, access denied", SecurityErrorCode.BAD_CREDENTIALS);
        }
    }

    public ClientContext getAccumuloClient() {
        return this.context;
    }

    @Override
    public Instance getInstance() {
        return new Instance(){

            @Override
            public String getRootTabletLocation() {
                return ConnectorImpl.this.context.getRootTabletLocation();
            }

            @Override
            public List<String> getMasterLocations() {
                return ConnectorImpl.this.context.getManagerLocations();
            }

            @Override
            public String getInstanceID() {
                return ConnectorImpl.this.context.getInstanceID().canonical();
            }

            @Override
            public String getInstanceName() {
                return ConnectorImpl.this.context.getInstanceName();
            }

            @Override
            public String getZooKeepers() {
                return ConnectorImpl.this.context.getZooKeepers();
            }

            @Override
            public int getZooKeepersSessionTimeOut() {
                return ConnectorImpl.this.context.getZooKeepersSessionTimeOut();
            }

            @Override
            public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
                return Connector.from(ConnectorImpl.this.context);
            }
        };
    }

    @Override
    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        return this.context.createBatchScanner(tableName, authorizations, numQueryThreads);
    }

    @Override
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        return this.context.createBatchDeleter(tableName, authorizations, numQueryThreads, new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, BatchWriterConfig config) throws TableNotFoundException {
        return this.context.createBatchDeleter(tableName, authorizations, numQueryThreads, config);
    }

    @Override
    public BatchWriter createBatchWriter(String tableName, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        return this.context.createBatchWriter(tableName, new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public BatchWriter createBatchWriter(String tableName, BatchWriterConfig config) throws TableNotFoundException {
        return this.context.createBatchWriter(tableName, config);
    }

    @Override
    public MultiTableBatchWriter createMultiTableBatchWriter(long maxMemory, long maxLatency, int maxWriteThreads) {
        return this.context.createMultiTableBatchWriter(new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public MultiTableBatchWriter createMultiTableBatchWriter(BatchWriterConfig config) {
        return this.context.createMultiTableBatchWriter(config);
    }

    @Override
    public ConditionalWriter createConditionalWriter(String tableName, ConditionalWriterConfig config) throws TableNotFoundException {
        return this.context.createConditionalWriter(tableName, config);
    }

    @Override
    public Scanner createScanner(String tableName, Authorizations authorizations) throws TableNotFoundException {
        return this.context.createScanner(tableName, authorizations);
    }

    @Override
    public String whoami() {
        return this.context.whoami();
    }

    @Override
    public TableOperations tableOperations() {
        return this.context.tableOperations();
    }

    @Override
    public NamespaceOperations namespaceOperations() {
        return this.context.namespaceOperations();
    }

    @Override
    public SecurityOperations securityOperations() {
        return this.context.securityOperations();
    }

    @Override
    public InstanceOperations instanceOperations() {
        return this.context.instanceOperations();
    }

    @Override
    public ReplicationOperations replicationOperations() {
        return this.context.replicationOperations();
    }
}

