/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TimedOutException
extends RuntimeException {
    private final HashSet<String> timedoutServers = new HashSet();
    private static final long serialVersionUID = 1L;

    private static String shorten(Set<String> set) {
        if (set.size() < 10) {
            return set.toString();
        }
        return String.valueOf(new ArrayList<String>(set).subList(0, 10)) + " ... " + (set.size() - 10) + " servers not shown";
    }

    public TimedOutException(Set<String> timedoutServers) {
        super("Servers timed out " + TimedOutException.shorten(timedoutServers));
        this.timedoutServers.addAll(timedoutServers);
    }

    public TimedOutException(String msg) {
        super(msg);
    }

    public Set<String> getTimedOutSevers() {
        return Collections.unmodifiableSet(this.timedoutServers);
    }
}

