/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.io.Text;

public class RowIterator
implements Iterator<Iterator<Map.Entry<Key, Value>>> {
    private final PeekingIterator<Map.Entry<Key, Value>> iter;
    private long count = 0L;
    private SingleRowIter lastIter = null;

    public RowIterator(Iterator<Map.Entry<Key, Value>> iterator) {
        this.iter = new PeekingIterator<Map.Entry<Key, Value>>(iterator);
    }

    public RowIterator(Iterable<Map.Entry<Key, Value>> iterable) {
        this(iterable.iterator());
    }

    @Override
    public boolean hasNext() {
        if (this.lastIter != null) {
            this.lastIter.consume();
            this.count += this.lastIter.getCount();
            this.lastIter = null;
        }
        return this.iter.hasNext();
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastIter = new SingleRowIter(this.iter);
        return this.lastIter;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public long getKVCount() {
        return this.count;
    }

    private static class SingleRowIter
    implements Iterator<Map.Entry<Key, Value>> {
        private final PeekingIterator<Map.Entry<Key, Value>> source;
        private Text currentRow = null;
        private long count = 0L;
        private boolean disabled = false;

        public SingleRowIter(PeekingIterator<Map.Entry<Key, Value>> source) {
            this.source = source;
            if (source.hasNext()) {
                this.currentRow = source.peek().getKey().getRow();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.disabled) {
                throw new IllegalStateException("SingleRowIter no longer valid");
            }
            return this.currentRow != null;
        }

        @Override
        public Map.Entry<Key, Value> next() {
            if (this.disabled) {
                throw new IllegalStateException("SingleRowIter no longer valid");
            }
            return this._next();
        }

        private Map.Entry<Key, Value> _next() {
            if (this.currentRow == null) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Map.Entry<Key, Value> kv = this.source.next();
            if (!this.source.hasNext() || !this.source.peek().getKey().getRow().equals((Object)this.currentRow)) {
                this.currentRow = null;
            }
            return kv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public long getCount() {
            return this.count;
        }

        public void consume() {
            this.disabled = true;
            while (this.currentRow != null) {
                this._next();
            }
        }
    }
}

