/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.security.Authorizations;

public class ConditionalWriterConfig {
    private static final Long DEFAULT_TIMEOUT = ConditionalWriterConfig.getDefaultTimeout();
    private static final Integer DEFAULT_MAX_WRITE_THREADS = Integer.parseInt(ClientProperty.CONDITIONAL_WRITER_THREADS_MAX.getDefaultValue());
    private Long timeout = null;
    private Integer maxWriteThreads = null;
    private Authorizations auths = null;
    private Durability durability = null;
    private String classLoaderContext = null;

    public ConditionalWriterConfig setAuthorizations(Authorizations auths) {
        Preconditions.checkArgument((auths != null ? 1 : 0) != 0, (Object)"auths is null");
        this.auths = auths;
        return this;
    }

    public ConditionalWriterConfig setTimeout(long timeout, TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout not allowed " + timeout);
        }
        this.timeout = timeout == 0L ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(Math.max(1L, timeUnit.toMillis(timeout)));
        return this;
    }

    public ConditionalWriterConfig setMaxWriteThreads(int maxWriteThreads) {
        if (maxWriteThreads <= 0) {
            throw new IllegalArgumentException("Max threads must be positive " + maxWriteThreads);
        }
        this.maxWriteThreads = maxWriteThreads;
        return this;
    }

    public ConditionalWriterConfig setDurability(Durability durability) {
        this.durability = durability;
        return this;
    }

    public Authorizations getAuthorizations() {
        return this.auths != null ? this.auths : Authorizations.EMPTY;
    }

    public long getTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.timeout != null ? this.timeout : DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public int getMaxWriteThreads() {
        return this.maxWriteThreads != null ? this.maxWriteThreads : DEFAULT_MAX_WRITE_THREADS;
    }

    public Durability getDurability() {
        return this.durability != null ? this.durability : Durability.DEFAULT;
    }

    private static long getDefaultTimeout() {
        long defVal = ConfigurationTypeHelper.getTimeInMillis(ClientProperty.CONDITIONAL_WRITER_TIMEOUT_MAX.getDefaultValue());
        return defVal != 0L ? defVal : Long.MAX_VALUE;
    }

    public void setClassLoaderContext(String classLoaderContext) {
        Objects.requireNonNull(classLoaderContext, "context name cannot be null");
        this.classLoaderContext = classLoaderContext;
    }

    public void clearClassLoaderContext() {
        this.classLoaderContext = null;
    }

    public String getClassLoaderContext() {
        return this.classLoaderContext;
    }

    private static <T> T merge(T o1, T o2) {
        if (o1 != null) {
            return o1;
        }
        return o2;
    }

    public ConditionalWriterConfig merge(ConditionalWriterConfig other) {
        ConditionalWriterConfig result = new ConditionalWriterConfig();
        result.timeout = ConditionalWriterConfig.merge(this.timeout, other.timeout);
        result.maxWriteThreads = ConditionalWriterConfig.merge(this.maxWriteThreads, other.maxWriteThreads);
        result.durability = ConditionalWriterConfig.merge(this.durability, other.durability);
        result.auths = ConditionalWriterConfig.merge(this.auths, other.auths);
        return result;
    }
}

