/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

public class ArrayOfDoublesSerDe
extends ArrayOfItemsSerDe<Double> {
    public byte[] serializeToByteArray(Double[] items) {
        byte[] bytes = new byte[8 * items.length];
        WritableMemory mem = WritableMemory.writableWrap((byte[])bytes);
        long offsetBytes = 0L;
        for (int i = 0; i < items.length; ++i) {
            mem.putDouble(offsetBytes, items[i].doubleValue());
            offsetBytes += 8L;
        }
        return bytes;
    }

    public Double[] deserializeFromMemory(Memory mem, int length) {
        Util.checkBounds(0L, 8L, mem.getCapacity());
        Double[] array = new Double[length];
        long offsetBytes = 0L;
        for (int i = 0; i < length; ++i) {
            array[i] = mem.getDouble(offsetBytes);
            offsetBytes += 8L;
        }
        return array;
    }
}

