/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.partial;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TEnum;
import org.apache.thrift.partial.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumCache {
    private static Logger LOG = LoggerFactory.getLogger(EnumCache.class);
    private Map<Class<? extends TEnum>, Map<Integer, TEnum>> classMap = new HashMap<Class<? extends TEnum>, Map<Integer, TEnum>>();

    public TEnum get(Class<? extends TEnum> enumClass, int value) {
        Validate.checkNotNull(enumClass, "enumClass");
        Map<Integer, TEnum> valueMap = this.classMap.get(enumClass);
        if (valueMap == null && (valueMap = this.addClass(enumClass)) == null) {
            return null;
        }
        return valueMap.get(value);
    }

    private Map<Integer, TEnum> addClass(Class<? extends TEnum> enumClass) {
        try {
            Method valuesMethod = enumClass.getMethod("values", new Class[0]);
            TEnum[] enumValues = (TEnum[])valuesMethod.invoke(null, new Object[0]);
            HashMap<Integer, TEnum> valueMap = new HashMap<Integer, TEnum>();
            for (TEnum enumValue : enumValues) {
                valueMap.put(enumValue.getValue(), enumValue);
            }
            this.classMap.put(enumClass, valueMap);
            return valueMap;
        }
        catch (NoSuchMethodException e) {
            LOG.error("enum class does not have values() method", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.error("Enum.values() method should be public!", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.error("Enum.values() threw exception", (Throwable)e);
            return null;
        }
    }
}

