/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GuardianStringKeyMultivaluedMap<V>
implements MultivaluedMap<String, V> {
    private final MultivaluedMap<String, V> inner;
    private final Map<String, Boolean> guards = new HashMap<String, Boolean>();

    public GuardianStringKeyMultivaluedMap(MultivaluedMap<String, V> inner) {
        this.inner = inner;
    }

    public void putSingle(String key, V value) {
        this.observe(key);
        this.inner.putSingle((Object)key, value);
    }

    public void add(String key, V value) {
        this.observe(key);
        this.inner.add((Object)key, value);
    }

    public V getFirst(String key) {
        return (V)this.inner.getFirst((Object)key);
    }

    public void addAll(String key, V ... newValues) {
        this.observe(key);
        this.inner.addAll((Object)key, (Object[])newValues);
    }

    public void addAll(String key, List<V> valueList) {
        this.observe(key);
        this.inner.addAll((Object)key, valueList);
    }

    public void addFirst(String key, V value) {
        this.observe(key);
        this.inner.addFirst((Object)key, value);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, V> otherMap) {
        return this.inner.equalsIgnoreValueOrder(otherMap);
    }

    public int size() {
        return this.inner.size();
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.inner.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.inner.containsValue(value);
    }

    public List<V> get(Object key) {
        return (List)this.inner.get(key);
    }

    public List<V> put(String key, List<V> value) {
        this.observe(key);
        return (List)this.inner.put((Object)key, value);
    }

    public List<V> remove(Object key) {
        if (key != null) {
            this.observe(key.toString());
        }
        return (List)this.inner.remove(key);
    }

    public void putAll(Map<? extends String, ? extends List<V>> m) {
        for (String string : m.keySet()) {
            this.observe(string);
        }
        this.inner.putAll(m);
    }

    public void clear() {
        this.observeAll();
        this.inner.clear();
    }

    public Set<String> keySet() {
        return this.inner.keySet();
    }

    public Collection<List<V>> values() {
        return this.inner.values();
    }

    public Set<Map.Entry<String, List<V>>> entrySet() {
        return this.inner.entrySet();
    }

    public void setGuard(String key) {
        this.guards.put(key, false);
    }

    public Set<String> getGuards() {
        return this.guards.keySet();
    }

    public boolean isObservedAndReset(String key) {
        Boolean observed = this.guards.get(key);
        this.guards.put(key, false);
        return observed != null && observed != false;
    }

    private void observe(String key) {
        for (Map.Entry<String, Boolean> guard : this.guards.entrySet()) {
            if (!guard.getKey().equals(key)) continue;
            guard.setValue(true);
        }
    }

    private void observeAll() {
        for (Map.Entry<String, Boolean> guard : this.guards.entrySet()) {
            guard.setValue(true);
        }
    }

    public String toString() {
        return this.inner.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuardianStringKeyMultivaluedMap that = (GuardianStringKeyMultivaluedMap)o;
        return this.inner.equals(that.inner) && this.guards.equals(that.guards);
    }

    public int hashCode() {
        return Objects.hash(this.inner, this.guards);
    }
}

