/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tablets;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.server.ServerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueNameAllocator {
    private static final Logger log = LoggerFactory.getLogger(UniqueNameAllocator.class);
    private static final SecureRandom random = new SecureRandom();
    private static final Property MIN_PROP = Property.GENERAL_FILE_NAME_ALLOCATION_BATCH_SIZE_MIN;
    private static final Property MAX_PROP = Property.GENERAL_FILE_NAME_ALLOCATION_BATCH_SIZE_MAX;
    private static final int DEFAULT_MIN = DefaultConfiguration.getInstance().getCount(MIN_PROP);
    private final ServerContext context;
    private final String nextNamePath;
    private long next = 0L;
    private long maxAllocated = 0L;

    public UniqueNameAllocator(ServerContext context) {
        this.context = context;
        this.nextNamePath = "/accumulo/" + String.valueOf(context.getInstanceID()) + "/next_file";
    }

    public synchronized String getNextName() {
        while (this.next >= this.maxAllocated) {
            int allocate = this.getAllocation();
            try {
                byte[] max = this.context.getZooReaderWriter().mutateExisting(this.nextNamePath, currentValue -> {
                    long l = Long.parseLong(new String(currentValue, StandardCharsets.UTF_8), 36);
                    return Long.toString(l + (long)allocate, 36).getBytes(StandardCharsets.UTF_8);
                });
                this.maxAllocated = Long.parseLong(new String(max, StandardCharsets.UTF_8), 36);
                this.next = this.maxAllocated - (long)allocate;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return new String(FastFormat.toZeroPaddedString((long)this.next++, (int)7, (int)36, (byte[])new byte[0]), StandardCharsets.UTF_8);
    }

    private int getAllocation() {
        int minAllocation = this.context.getConfiguration().getCount(MIN_PROP);
        int maxAllocation = this.context.getConfiguration().getCount(MAX_PROP);
        if (minAllocation <= 0) {
            log.warn("{} was set to {}, but must be greater than 0. Using the default ({}).", new Object[]{MIN_PROP.getKey(), minAllocation, DEFAULT_MIN});
            minAllocation = DEFAULT_MIN;
        }
        if (maxAllocation < minAllocation) {
            log.warn("{} was set to {}, must be greater than or equal to {} ({}). Using {}.", new Object[]{MAX_PROP.getKey(), maxAllocation, MIN_PROP.getKey(), minAllocation, minAllocation});
            maxAllocation = minAllocation;
        }
        int actualBatchSize = minAllocation + random.nextInt(maxAllocation - minAllocation + 1);
        log.debug("Allocating {} filenames", (Object)actualBatchSize);
        return actualBatchSize;
    }
}

