/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.log;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.ServerContext;
import org.apache.hadoop.fs.Path;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalStateManager {
    private static final Logger log = LoggerFactory.getLogger(WalStateManager.class);
    public static final String ZWALS = "/wals";
    private final ClientContext context;
    private final ZooReaderWriter zoo;
    private volatile boolean checkedExistance = false;

    public WalStateManager(ServerContext context) {
        this.context = context;
        this.zoo = context.getZooReaderWriter();
    }

    private String root() throws WalMarkerException {
        String root = this.context.getZooKeeperRoot() + ZWALS;
        try {
            if (!this.checkedExistance && !this.zoo.exists(root)) {
                this.zoo.putPersistentData(root, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            }
            this.checkedExistance = true;
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
        return root;
    }

    public void initWalMarker(TServerInstance tsi) throws WalMarkerException {
        byte[] data = new byte[]{};
        try {
            this.zoo.putPersistentData(this.root() + "/" + String.valueOf(tsi), data, ZooUtil.NodeExistsPolicy.FAIL);
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
    }

    public void addNewWalMarker(TServerInstance tsi, Path path) throws WalMarkerException {
        this.updateState(tsi, path, WalState.OPEN);
    }

    private void updateState(TServerInstance tsi, Path path, WalState state) throws WalMarkerException {
        byte[] data = (String.valueOf((Object)state) + "," + String.valueOf(path)).getBytes(StandardCharsets.UTF_8);
        try {
            ZooUtil.NodeExistsPolicy policy = ZooUtil.NodeExistsPolicy.OVERWRITE;
            if (state == WalState.OPEN) {
                policy = ZooUtil.NodeExistsPolicy.FAIL;
            }
            log.debug("Setting {} to {}", (Object)path.getName(), (Object)state);
            this.zoo.putPersistentData(this.root() + "/" + String.valueOf(tsi) + "/" + path.getName(), data, policy);
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
    }

    public void walUnreferenced(TServerInstance tsi, Path path) throws WalMarkerException {
        this.updateState(tsi, path, WalState.UNREFERENCED);
    }

    private static Pair<WalState, Path> parse(byte[] data) {
        String[] parts = new String(data, StandardCharsets.UTF_8).split(",");
        return new Pair((Object)WalState.valueOf(parts[0]), (Object)new Path(parts[1]));
    }

    public List<Path> getWalsInUse(TServerInstance tsi) throws WalMarkerException {
        ArrayList<Path> result = new ArrayList<Path>();
        try {
            String zpath = this.root() + "/" + String.valueOf(tsi);
            this.zoo.sync(zpath);
            for (String child : this.zoo.getChildren(zpath)) {
                Pair<WalState, Path> parts;
                byte[] zdata = null;
                try {
                    zdata = this.zoo.getData(zpath + "/" + child);
                }
                catch (KeeperException.NoNodeException e) {
                    log.debug("WAL state removed {} {} during getWalsInUse.  Likely a race condition between manager and GC.", (Object)tsi, (Object)child);
                }
                if (zdata == null || (parts = WalStateManager.parse(zdata)).getFirst() == WalState.UNREFERENCED) continue;
                result.add((Path)parts.getSecond());
            }
        }
        catch (KeeperException.NoNodeException e) {
            log.debug("{} has no wal entry in zookeeper, assuming no logs", (Object)tsi);
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
        return result;
    }

    public Map<TServerInstance, List<UUID>> getAllMarkers() throws WalMarkerException {
        HashMap<TServerInstance, List<UUID>> result = new HashMap<TServerInstance, List<UUID>>();
        try {
            String path = this.root();
            for (String child : this.zoo.getChildren(path)) {
                TServerInstance inst = new TServerInstance(child);
                List logs = result.computeIfAbsent(inst, k -> new ArrayList());
                for (String idString : this.zoo.getChildren(path + "/" + child)) {
                    logs.add(UUID.fromString(idString));
                }
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
        return result;
    }

    public Pair<WalState, Path> state(TServerInstance instance, UUID uuid) throws WalMarkerException {
        try {
            String path = this.root() + "/" + String.valueOf(instance) + "/" + String.valueOf(uuid);
            return WalStateManager.parse(this.zoo.getData(path));
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
    }

    public Map<Path, WalState> getAllState() throws WalMarkerException {
        HashMap<Path, WalState> result = new HashMap<Path, WalState>();
        for (Map.Entry<TServerInstance, List<UUID>> entry : this.getAllMarkers().entrySet()) {
            for (UUID id : entry.getValue()) {
                Pair<WalState, Path> state = this.state(entry.getKey(), id);
                result.put((Path)state.getSecond(), (WalState)((Object)state.getFirst()));
            }
        }
        return result;
    }

    public void removeWalMarker(TServerInstance instance, UUID uuid) throws WalMarkerException {
        try {
            log.debug("Removing {}", (Object)uuid);
            String path = this.root() + "/" + String.valueOf(instance) + "/" + String.valueOf(uuid);
            this.zoo.delete(path);
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
    }

    public void forget(TServerInstance instance) throws WalMarkerException {
        String path = this.root() + "/" + String.valueOf(instance);
        try {
            this.zoo.recursiveDelete(path, ZooUtil.NodeMissingPolicy.FAIL);
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
    }

    public void closeWal(TServerInstance instance, Path path) throws WalMarkerException {
        this.updateState(instance, path, WalState.CLOSED);
    }

    public static class WalMarkerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public WalMarkerException(Exception ex) {
            super(ex);
        }
    }

    public static enum WalState {
        OPEN,
        CLOSED,
        UNREFERENCED;

    }
}

