/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.init;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.crypto.CryptoFactoryLoader;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.spi.fs.VolumeChooserEnvironment;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.PropStore;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.fs.VolumeChooserEnvironmentImpl;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.init.InitialConfiguration;
import org.apache.accumulo.server.init.Initialize;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSystemInitializer {
    private static final String TABLE_TABLETS_TABLET_DIR = "table_info";
    private static final Logger log = LoggerFactory.getLogger(FileSystemInitializer.class);
    private final InitialConfiguration initConfig;

    FileSystemInitializer(InitialConfiguration initConfig, ZooReaderWriter zoo, InstanceId uuid) {
        this.initConfig = initConfig;
    }

    void initialize(VolumeManager fs, String rootTabletDirUri, String rootTabletFileUri, ServerContext context) throws IOException, InterruptedException, KeeperException {
        SiteConfiguration siteConfig = this.initConfig.getSiteConf();
        this.initSystemTablesConfig(context);
        Text splitPoint = MetadataSchema.TabletsSection.getRange().getEndKey().getRow();
        VolumeChooserEnvironmentImpl chooserEnv = new VolumeChooserEnvironmentImpl(VolumeChooserEnvironment.Scope.INIT, MetadataTable.ID, splitPoint, context);
        String tableMetadataTabletDirName = TABLE_TABLETS_TABLET_DIR;
        String tableMetadataTabletDirUri = fs.choose(chooserEnv, context.getBaseUris()) + "/tables/" + String.valueOf(MetadataTable.ID) + "/" + tableMetadataTabletDirName;
        chooserEnv = new VolumeChooserEnvironmentImpl(VolumeChooserEnvironment.Scope.INIT, Initialize.REPL_TABLE_ID, null, context);
        String replicationTableDefaultTabletDirName = "default_tablet";
        String replicationTableDefaultTabletDirUri = fs.choose(chooserEnv, context.getBaseUris()) + "/tables/" + String.valueOf(Initialize.REPL_TABLE_ID) + "/" + replicationTableDefaultTabletDirName;
        chooserEnv = new VolumeChooserEnvironmentImpl(VolumeChooserEnvironment.Scope.INIT, MetadataTable.ID, null, context);
        String defaultMetadataTabletDirName = "default_tablet";
        String defaultMetadataTabletDirUri = fs.choose(chooserEnv, context.getBaseUris()) + "/tables/" + String.valueOf(MetadataTable.ID) + "/" + defaultMetadataTabletDirName;
        this.createDirectories(fs, rootTabletDirUri, tableMetadataTabletDirUri, defaultMetadataTabletDirUri, replicationTableDefaultTabletDirUri);
        String ext = FileOperations.getNewFileExtension((AccumuloConfiguration)DefaultConfiguration.getInstance());
        String metadataFileName = tableMetadataTabletDirUri + "/0_1." + ext;
        Tablet replicationTablet = new Tablet(Initialize.REPL_TABLE_ID, replicationTableDefaultTabletDirName, null, null, new String[0]);
        this.createMetadataFile(fs, metadataFileName, (AccumuloConfiguration)siteConfig, replicationTablet);
        Tablet tablesTablet = new Tablet(MetadataTable.ID, tableMetadataTabletDirName, null, splitPoint, metadataFileName);
        Tablet defaultTablet = new Tablet(MetadataTable.ID, defaultMetadataTabletDirName, splitPoint, null, new String[0]);
        this.createMetadataFile(fs, rootTabletFileUri, (AccumuloConfiguration)siteConfig, tablesTablet, defaultTablet);
    }

    private void createDirectories(VolumeManager fs, String ... dirs) throws IOException {
        for (String s : dirs) {
            Path dir = new Path(s);
            try {
                FileStatus fstat = fs.getFileStatus(dir);
                if (fstat.isDirectory()) continue;
                log.error("FATAL: location {} exists but is not a directory", (Object)dir);
                return;
            }
            catch (FileNotFoundException fnfe) {
                if (fs.mkdirs(dir)) continue;
                log.error("FATAL: unable to create directory {}", (Object)dir);
                return;
            }
        }
    }

    private void initSystemTablesConfig(ServerContext context) throws IOException, InterruptedException, KeeperException {
        this.setTableProperties(context, RootTable.ID, this.initConfig.getRootTableConf());
        this.setTableProperties(context, RootTable.ID, this.initConfig.getRootMetaConf());
        this.setTableProperties(context, MetadataTable.ID, this.initConfig.getRootMetaConf());
        this.setTableProperties(context, MetadataTable.ID, this.initConfig.getMetaTableConf());
        this.setTableProperties(context, Initialize.REPL_TABLE_ID, this.initConfig.getReplTableConf());
    }

    private void setTableProperties(ServerContext context, TableId tableId, HashMap<String, String> props) {
        TablePropKey tablePropKey;
        PropStore propStore = context.getPropStore();
        if (propStore.exists(tablePropKey = TablePropKey.of(context, tableId))) {
            propStore.putAll(tablePropKey, props);
        } else {
            propStore.create(tablePropKey, props);
        }
    }

    private void createMetadataFile(VolumeManager volmanager, String fileName, AccumuloConfiguration conf, Tablet ... tablets) throws IOException {
        TreeMap<Key, Value> sorted = new TreeMap<Key, Value>();
        for (Tablet tablet : tablets) {
            this.createEntriesForTablet(sorted, tablet);
        }
        FileSystem fs = volmanager.getFileSystemByPath(new Path(fileName));
        CryptoService cs = CryptoFactoryLoader.getServiceForServer((AccumuloConfiguration)conf);
        FileSKVWriter tabletWriter = FileOperations.getInstance().newWriterBuilder().forFile(fileName, fs, fs.getConf(), cs).withTableConfiguration(conf).build();
        tabletWriter.startDefaultLocalityGroup();
        for (Map.Entry<Key, Value> entry : sorted.entrySet()) {
            tabletWriter.append(entry.getKey(), entry.getValue());
        }
        tabletWriter.close();
    }

    private void createEntriesForTablet(TreeMap<Key, Value> map, Tablet tablet) {
        Value EMPTY_SIZE = new DataFileValue(0L, 0L).encodeAsValue();
        Text extent = new Text(MetadataSchema.TabletsSection.encodeRow((TableId)tablet.tableId, (Text)tablet.endRow));
        this.addEntry(map, extent, MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN, new Value((CharSequence)tablet.dirName));
        this.addEntry(map, extent, MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN, new Value((CharSequence)new MetadataTime(0L, TimeType.LOGICAL).encode()));
        this.addEntry(map, extent, MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.encodePrevEndRow((Text)tablet.prevEndRow));
        for (String file : tablet.files) {
            this.addEntry(map, extent, new ColumnFQ(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, new Text(file)), EMPTY_SIZE);
        }
    }

    private void addEntry(TreeMap<Key, Value> map, Text row, ColumnFQ col, Value value) {
        map.put(new Key(row, col.getColumnFamily(), col.getColumnQualifier(), 0L), value);
    }

    private static class Tablet {
        TableId tableId;
        String dirName;
        Text prevEndRow;
        Text endRow;
        String[] files;

        Tablet(TableId tableId, String dirName, Text prevEndRow, Text endRow, String ... files) {
            this.tableId = tableId;
            this.dirName = dirName;
            this.prevEndRow = prevEndRow;
            this.endRow = endRow;
            this.files = files;
        }
    }
}

