/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.net.URLConnection;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.impl.DefaultFileContentInfo;

public class FileContentInfoFilenameFactory
implements FileContentInfoFactory {
    private static final FileContentInfo NULL_INSTANCE = new DefaultFileContentInfo(null, null);

    @Override
    public FileContentInfo create(FileContent fileContent) {
        String contentType = null;
        String name = fileContent.getFile().getName().getBaseName();
        if (name != null) {
            contentType = URLConnection.getFileNameMap().getContentTypeFor(name);
        }
        if (contentType == null) {
            return NULL_INSTANCE;
        }
        return new DefaultFileContentInfo(contentType, null);
    }
}

