/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.constraints;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.data.constraints.Constraint;
import org.apache.accumulo.core.dataImpl.ComparableBytes;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.tserver.constraints.SystemConstraint;
import org.apache.accumulo.tserver.constraints.UnsatisfiableConstraint;
import org.apache.hadoop.io.BinaryComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintChecker {
    private final ArrayList<Constraint> constraints = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(ConstraintChecker.class);

    public ConstraintChecker(AccumuloConfiguration conf) {
        try {
            String context = ClassLoaderUtil.tableContext((AccumuloConfiguration)conf);
            for (Map.Entry entry : conf.getAllPropertiesWithPrefix(Property.TABLE_CONSTRAINT_PREFIX).entrySet()) {
                if (!((String)entry.getKey()).startsWith(Property.TABLE_CONSTRAINT_PREFIX.getKey())) continue;
                String className = (String)entry.getValue();
                Class clazz = ClassLoaderUtil.loadClass((String)context, (String)className, Constraint.class);
                log.debug("Loaded constraint {} for {}", (Object)clazz.getName(), (Object)((TableConfiguration)conf).getTableId());
                this.constraints.add((Constraint)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            this.constraints.clear();
            this.constraints.add(new UnsatisfiableConstraint(-1, "Failed to load constraints, not accepting mutations."));
            log.error("Failed to load constraints " + String.valueOf(((TableConfiguration)conf).getTableId()) + " " + String.valueOf(e), (Throwable)e);
        }
    }

    @VisibleForTesting
    ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    private static Violations addViolation(Violations violations, ConstraintViolationSummary cvs) {
        if (violations == null) {
            violations = new Violations();
        }
        violations.add(cvs);
        return violations;
    }

    public Violations check(Constraint.Environment env, Mutation m) {
        if (!this.tabletContains(env.getTablet(), (BinaryComparable)new ComparableBytes(m.getRow()))) {
            Violations violations = new Violations();
            ConstraintViolationSummary cvs = new ConstraintViolationSummary(SystemConstraint.class.getName(), -1, "Mutation outside of tablet extent", 1L);
            violations.add(cvs);
            return violations;
        }
        Violations violations = null;
        for (Constraint constraint : this.getConstraints()) {
            try {
                List violationCodes = constraint.check(env, m);
                if (violationCodes == null) continue;
                String className = constraint.getClass().getName();
                for (Short vcode : violationCodes) {
                    violations = ConstraintChecker.addViolation(violations, new ConstraintViolationSummary(className, vcode.shortValue(), constraint.getViolationDescription(vcode.shortValue()), 1L));
                }
            }
            catch (Exception e) {
                String msg;
                short vcode;
                log.warn("CONSTRAINT FAILED : {}", (Object)e.getMessage(), (Object)e);
                if (e instanceof NullPointerException) {
                    vcode = -1;
                    msg = "threw NullPointerException";
                } else if (e instanceof ArrayIndexOutOfBoundsException) {
                    vcode = -2;
                    msg = "threw ArrayIndexOutOfBoundsException";
                } else if (e instanceof NumberFormatException) {
                    vcode = -3;
                    msg = "threw NumberFormatException";
                } else {
                    vcode = -100;
                    msg = "threw some Exception";
                }
                violations = ConstraintChecker.addViolation(violations, new ConstraintViolationSummary(constraint.getClass().getName(), vcode, "CONSTRAINT FAILED : " + msg, 1L));
            }
        }
        return violations;
    }

    public boolean tabletContains(TabletId tablet, BinaryComparable row) {
        if (row == null) {
            throw new IllegalArgumentException("Passing null to contains is ambiguous, could be in first or last extent of table");
        }
        return !(tablet.getPrevEndRow() != null && tablet.getPrevEndRow().compareTo(row) >= 0 || tablet.getEndRow() != null && tablet.getEndRow().compareTo(row) < 0);
    }
}

